<?php

/**
 * Function BX_archive
 * ------------------------------------------------------
 * This function is based on WP's built-in get_archives()
 * It outputs the following:
 *
 * <h3><a href="link">Month Year</a></h3>
 * <ul class="postspermonth">
 *     <li><a href="link">Post title</a> (Comment count)</li>
 *     [..]
 * </ul>
 */

function BX_archive()
{
global $month, $wpdb;
$now = current_time('mysql');
$arcresults = $wpdb->get_results("SELECT DISTINCT YEAR(post_date) AS year, MONTH(post_date) AS month, count(ID) as posts FROM " . $wpdb->posts . " WHERE post_date <'" . $now . "' AND post_status='publish' AND post_password='' GROUP BY YEAR(post_date), MONTH(post_date) ORDER BY post_date DESC");

if ($arcresults) {
foreach ($arcresults as $arcresult) {
$url  = get_month_link($arcresult->year, $arcresult->month);
$text = sprintf('%s %d', $month[zeroise($arcresult->month,2)], $arcresult->year);
echo get_archives_link($url, $text, '','<h3>','</h3>');

$thismonth   = zeroise($arcresult->month,2);
$thisyear = $arcresult->year;

$arcresults2 = $wpdb->get_results("SELECT ID, post_date, post_title, comment_status FROM " . $wpdb->posts . " WHERE post_date LIKE '$thisyear-$thismonth-%' AND post_status='publish' AND post_password='' ORDER BY post_date DESC");

if ($arcresults2) {
echo "<ul class=\"postspermonth\">\n";
foreach ($arcresults2 as $arcresult2) {
if ($arcresult2->post_date != '0000-00-00 00:00:00') {
$url = get_permalink($arcresult2->ID);
$arc_title = $arcresult2->post_title;

if ($arc_title) $text = strip_tags($arc_title);
else $text = $arcresult2->ID;

echo "<li>".get_archives_link($url, $text, '');
$comments = mysql_query("SELECT * FROM " . $wpdb->comments . " WHERE comment_post_ID=" . $arcresult2->ID);
$comments_count = mysql_num_rows($comments);
if ($arcresult2->comment_status == "open" OR $comments_count > 0) echo '&nbsp;('.$comments_count.')';
echo "</li>\n";
}
}
echo "</ul>\n";
}
}
}
}

/**
 * Function BX_get_recent_posts
 * Outputs an unorderd list of the most recent posts.
 * $current_id this post will be excluded
 * $limitmax. number of posts
 */

function BX_get_recent_posts($current_id, $limit)
{
global $wpdb;
$posts = $wpdb->get_results("SELECT ID, post_title FROM " . $wpdb->posts . " WHERE post_status='publish' AND post_type='post'  ORDER BY post_date DESC LIMIT " . $limit);
foreach ($posts as $post) {
$post_title = stripslashes($post->post_title);
$permalink  = get_permalink($post->ID);
if ($post->ID != $current_id) echo "<li><a href=\"" . $permalink . "\">" . $post_title . "</a></li>\n";
}
}

/**
 * Function BX_get_pages
 * ------------------------------------------------------
 * Returns the following of all WP pages:
 * ID, title, name, (content)
 * $withcontentspecifies if the page's content will
 *also be returned
 */

function BX_get_pages($with_content = '')
{
global $wpdb;
$query = "SELECT ID, post_title, post_name FROM " . $wpdb->posts . " WHERE post_type='page' OR post_status='static' ORDER BY menu_order ASC";
if ($with_content == "with_content") {
$query = "SELECT ID, post_title,post_name, post_content FROM " . $wpdb->posts . " WHERE post_type='page' OR post_status='static' ORDER BY menu_order ASC";
}
return $wpdb->get_results($query);
}

/**
 * Function BX_excluded_pages()
 * ------------------------------------------------------
 * Returns the Blix default pages that are excluded
 * from the navigation in the sidebar
 *
 */

function BX_excluded_pages()
{
$pages = BX_get_pages();
$exclude = "";
if ($pages) {
foreach ($pages as $page) {
$page_id = $page->ID;
   $page_name = $page->post_name;
   if ($page_name == "archives" || $page_name == "about"  || $page_name == "about_short" || $page_name == "contact") {
   $exclude .= ", ".$page_id;
   }
   }
   $exclude = preg_replace("/^, (.*?)/","\\1",$exclude);
   }
   return $exclude;
}


/**
 * Function BX_shift_down_headlines
 * ------------------------------------------------------
 * Shifts down the headings by one level (<h5> --> </h6>)
 * Used for posts in the archive
 */

function BX_shift_down_headlines($text)
{
$text = apply_filters('the_content', $text);
$text = preg_replace("/h5>/","h6>",$text);
$text = preg_replace("/h4>/","h5>",$text);
$text = preg_replace("/h3>/","h4>",$text);
echo $text;
}


/**
 * Function BX_remove_p
 * ------------------------------------------------------
 * Removes the opening <p> and closing </p> from $text
 * Used for the short about text on the front page
 */

function BX_remove_p($text)
{
$text = apply_filters('the_content', $text);
$text = preg_replace("/^[\t|\n]?<p>(.*)/","\\1",$text); // opening <p>
$text = preg_replace("/(.*)<\/p>[\t|\n]$/","\\1",$text); // closing </p>
return $text;
}

// below are widget custom to custom the widget looks without the default //

if ( function_exists('register_sidebars') )  {

register_sidebars(1, array(
'before_widget' => '',
'after_widget' => '',
'before_title' => '<h4>',
'after_title' => '</h4>',
));

}

// below are widget custom to custom the widget looks without the default //

function widget_mytheme_myRecent() {
?>

<h4><em>Recent Blog Posts</em></h4>

<ul class="posts">
<?php BX_get_recent_posts($p,10); ?>
</ul>

<?php
}
if ( function_exists('register_sidebar_widget') )
register_sidebar_widget(__('Recent Blog Posts'), 'widget_mytheme_myRecent');

function widget_mytheme_myCategories() {
?>

<h4><em>Categories</em></h4>

<ul class="categories">
<?php wp_list_cats('sort_column=name&hide_empty=0'); ?> 
</ul>

<?php
}
if ( function_exists('register_sidebar_widget') )
register_sidebar_widget(__('Categories'), 'widget_mytheme_myCategories');

function widget_mytheme_myTags() {
?>

<?php if ( function_exists('wp_tag_cloud')){ ?>
<h4><em>Tags</em></h4>

<ul class="categories">
<?php wp_tag_cloud('smallest=8&largest=22&number=50'); ?>
</ul>
<?php } ?>

<?php
}
if ( function_exists('register_sidebar_widget') )
register_sidebar_widget(__('Tags'), 'widget_mytheme_myTags');

function widget_mytheme_myAdverts() {
?>
<? include("adsense.php"); ?>
<div style="padding-left:30px; padding-bottom:5px;">
<script type="text/javascript"><!--
google_ad_client = "<?=$GoogleADID?>";
google_ad_width = 160;
google_ad_height = 600;
google_ad_format = "160x600_as";
google_ad_type = "text_image";
google_ad_channel ="";
google_color_border = "<?=$Googleborder?>";
google_color_bg = "<?=$Googlebg?>";
google_color_link = "<?=$Googlelink?>";
google_color_url = "<?=$Googleurl?>";
google_color_text = "<?=$Googletext?>";
//--></script>
<script type="text/javascript"
  src="http://pagead2.googlesyndication.com/pagead/show_ads.js">
</script>
</div>

<?php
}
if ( function_exists('register_sidebar_widget') )
register_sidebar_widget(__('Adverts'), 'widget_mytheme_myAdverts');

function widget_mytheme_myarchives() {
?>

<h4><em>Posts by Month</em></h4>

<ul class="months">
<?php get_archives('monthly','','','<li>','</li>',''); ?>
</ul>

<?php
}
if ( function_exists('register_sidebar_widget') )
register_sidebar_widget(__('Archives'), 'widget_mytheme_myarchives');

function widget_mytheme_myBlogroll() {
?>

<h4><em>Blogroll</em></h4>

<ul class="links">
<?php get_links('-1', '<li>', '</li>', '', 0, 'name', 0, 0, -1, 0); ?>
</ul>

<?php
}
if ( function_exists('register_sidebar_widget') )
register_sidebar_widget(__('Blogroll'), 'widget_mytheme_myBlogroll');

function widget_mytheme_myRss() {
?>

<?php if (is_home()) { ?>
<h4><em>RSS Feeds</em></h4>

<ul class="feeds">
<li><a href="<?php bloginfo_rss('rss2_url'); ?> ">Entries (RSS)</a></li>
<li><a href="<?php bloginfo_rss('comments_rss2_url'); ?> ">Comments (RSS)</a></li>
</ul>
<?php } ?>

<?php
}
if ( function_exists('register_sidebar_widget') )
register_sidebar_widget(__('Rss'), 'widget_mytheme_myRss');

function widget_mytheme_myPages() {
?>

<h4><em>Pages</em></h4>
<ul class="pages">
<?php
$excluded = BX_excluded_pages();
wp_list_pages('title_li=&sort_column=menu_order&exclude='.$excluded);
?>
</ul>

<?php
}
if ( function_exists('register_sidebar_widget') )
register_sidebar_widget(__('Pages'), 'widget_mytheme_myPages');

?>