var activeSlide = 0;

(function($) {
	$(document).ready(function() {

		// Position slides
		$("#featured li").each(function(index) {
			$(this).css({
				'position': 'absolute',
				'top': '0px',
				'left': (609 * index) + 'px'
			});
		});
		
		// Setup slide controls
		$("#featured li").each(function(index) {
			$("#featured-controls").append(
				"<a class='featured-" + index + "'></a>"
			);
		});
		$("#featured-controls a").click(function() {
			var regEx = /featured-([0-9]+)/g;
			var slide = regEx.exec($(this).attr('class'))[1];
			clearInterval(interval);
			interval = setInterval(featuredAdvance, 5000);			
			featuredJumpTo(slide);
		});
		
		// Set active slide
		$("#featured-controls .featured-0").toggleClass('active', true);
	
	});
	
	// Jump to slide
	function featuredJumpTo(index) {
		activeSlide = index;
		$("#featured-controls a").toggleClass('active', false);
		$("#featured-controls .featured-" + index).toggleClass('active', true);
		$("#featured ul").animate({
			'left': -index * 609 + 'px'
		});
	}
	
	// Advance slide
	function featuredAdvance() {
		activeSlide++;
		if (activeSlide >= $("#featured li").length) activeSlide = 0;
		featuredJumpTo(activeSlide);
	}
	
	// Auto-advance
	var interval = setInterval(featuredAdvance, 5000);
	
})(jQuery);

