<?php wp_enqueue_script( 'featured', get_template_directory_uri() . '/js/featured.js', array( 'jquery' ) ); ?>

<?php get_header(); ?>	



<div id="content">



	<?php



		/**

		 * Featured posts

		 */



		// Query for featured ("sticky") posts

		$featured = new WP_Query( array(

			'post__in' => get_option( 'sticky_posts' ),

			'post_status' => 'publish',

			'posts_per_page' => 10,

			'no_found_rows' => true,

		) );

	

		// Output featured posts

		if ( $featured->have_posts() ):

	

	?>

	

		<aside id="sidebar-above">

			<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Sidebar Above') ) : ?>

			<?php endif; ?>

		</aside>

		

		<div id="featured">

			<ul>

				<?php while ( $featured->have_posts() ) : $featured->the_post(); ?>

					<li id="featured-<?php the_ID(); ?>">

						<a href="<?php the_permalink(); ?>">

							<?php if ( has_post_thumbnail() ): ?>

								<?php the_post_thumbnail( 'featured' ); ?>

							<?php else: ?>

								<img src="<?php echo get_template_directory_uri(); ?>/images/featured-default.png" />

							<?php endif; ?>

						</a>

						<div class="description">

							<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

							<span class="meta">Posted by <?php the_author(); ?> in <?php the_category(','); ?> on <?php echo get_the_date(); ?></span>

						</div>

					</li>

				<?php endwhile; ?>

			</ul>

		</div>

		<div id="featured-controls"></div>

		

	<?php endif; ?>



	<?php



		/**

		 * Regular posts

		 */

		

		// Query for recent, non-sticky posts

		$recent = new WP_Query(

			array(

				'order' => 'DESC',

				'post__not_in' => get_option( 'sticky_posts' ),

				'post_status' => 'publish',

				'no_found_rows' => true,

				'paged' => $paged

			)

		);	



	?>	



	<div id="ad-strip">

		<div class="widget">

			<a id="podcast" href="http://www2.tsn.ca/winnipeg/listen/" target="_blank">Listen to Am 1290</a>

		</div>

		<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Home Page Strip') ) : ?>

		<?php endif; ?>

	</div>

	

	<aside id="sidebar-below">

		<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Sidebar Below') ) : ?>

		<?php endif; ?>

	</aside>

	

	<div id="before-content">

		<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Home Page Before Content') ) : ?>

		<?php endif; ?>

	</div>	

	

	<?php $count = $paged ? 10 : 0; ?>

	<?php while ( $recent->have_posts() ) : $recent->the_post(); $count++; ?>

		<article id="post-<?php the_ID(); ?>" <?php post_class( "article-$count" ); ?>>

			<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

			<?php if ( has_post_thumbnail() ): ?>

			 	<?php if (!$paged && $count <= 3) the_post_thumbnail( 'small' ); else the_post_thumbnail(); ?>

			<?php endif; ?>

			<?php the_excerpt(); ?>

			<span class="meta">Posted by <?php the_author(); ?> in <?php the_category(','); ?> on <?php echo get_the_date(); ?></span>			

		</article>

	<?php endwhile; ?>

	

	<div id="pagination">

		<span class="next"><?php next_posts_link( 'Older' ); ?></span>

		<span class="previous"><?php previous_posts_link( 'Newer' ); ?></span>

	</div>

	

</div>



<?php get_footer(); ?>

