<?php

/**
 * Setup post thumbnails
 */

if ( function_exists( 'add_theme_support' ) ) { 
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 120, 80, true );
	add_image_size( 'featured', 609, 291, true ); 
	add_image_size( 'small', 60, 60, true );
}

/**
 * Setup sidebars
 */

register_sidebar( array(
	'name' => 'Home Page Strip',
	'description' => 'Area on home page immediately below the featured stories.',
	'before_widget' => '<div class="widget">',
	'after_widget' => '</div>',
	'before_title' => '',
	'after_title' => '',
) );

register_sidebar( array(
	'name' => 'Home Page Before Content',
	'description' => 'Before content on home page.',
	'before_widget' => '<div class="widget">',
	'after_widget' => '</div>',
	'before_title' => '<h2>',
	'after_title' => '</h2>',
) );

register_sidebar( array(
	'name' => 'Sidebar Above',
	'description' => 'Sidebar appearing above the fold.',
	'before_widget' => '<div class="widget">',
	'after_widget' => '</div>',
	'before_title' => '<h3>',
	'after_title' => '</h3>',
) );

register_sidebar( array(
	'name' => 'Sidebar Below',
	'description' => 'Sidebar appearing below the fold.',
	'before_widget' => '<div class="widget">',
	'after_widget' => '</div>',
	'before_title' => '<h3>',
	'after_title' => '</h3>',
) );

register_sidebar( array(
	'name' => 'Before Content',
	'description' => 'Before content on internal pages.',
	'before_widget' => '<div class="widget">',
	'after_widget' => '</div>',
	'before_title' => '<h2>',
	'after_title' => '</h2>',
) );

register_sidebar( array(
	'name' => 'After Content',
	'description' => 'After content on internal pages.',
	'before_widget' => '<div class="widget">',
	'after_widget' => '</div>',
	'before_title' => '<h2>',
	'after_title' => '</h2>',
) );

/**
 * Setup menu
 *
 * @access  public
 * @return  void
 */
function illegalcurve_register_menus() {
	register_nav_menus(
		array( 
			'primary' => __( 'Primary Menu' ),
			'secondary' => __( 'Secondary Menu' )
		 )
	);
}
add_action( 'init', 'illegalcurve_register_menus' );