<?php wp_enqueue_script( 'featured', get_template_directory_uri() . '/js/featured.js', array( 'jquery' ) ); ?>
<?php get_header(); ?>	

<div id="content">
	
	<aside>
		<div id="sidebar-above">
			<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Sidebar Above') ) : ?>
			<?php endif; ?>
		</div>
		
		<div id="sidebar-below">
			<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Sidebar Below') ) : ?>
			<?php endif; ?>
		</div>
	</aside>
	
	<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Before Content') ) : ?>
	<?php endif; ?>	
	
	<?php while ( have_posts() ) :the_post(); ?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
			<?php if ( has_post_thumbnail() ) the_post_thumbnail(); ?>
			<?php the_excerpt(); ?>
			<span class="meta">Posted by <?php the_author(); ?> in <?php the_category(','); ?> on <?php echo get_the_date(); ?></span>			
		</article>
	<?php endwhile; ?>	

	<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('After Content') ) : ?>
	<?php endif; ?>	

	<div id="pagination">
		<span class="next"><?php next_posts_link( 'Older' ); ?></span>
		<span class="previous"><?php previous_posts_link( 'Newer' ); ?></span>
	</div>
	
</div>

<?php get_footer(); ?>
